Require Import Equations.Equations.
Require Import List Omega.
Import ListNotations.

Section list_size.
  Context {A : Type} (f : A -> nat).
  Equations list_size (l : list A) : nat :=
  list_size nil := 0;
  list_size (cons x l) :=
    S (f x + list_size l).
End list_size.

Section RoseTree.
  Context {A : Set}.

  Inductive rose : Set :=
  | leaf : A -> rose
  | node : list rose -> rose.

  Equations size (r : rose) : nat :=
  size (leaf _) := 0;
  size (node l) := S (list_size size l).

  Hint Extern 4 (_ < _) => simpl; omega :
    rec_decision.

  Equations(noeqns noind) elements (r : rose) :
    list A :=
  elements r by rec r (MR lt size) :=
  elements (leaf a) := [a];
  elements (node l) := aux l _

  where aux (x : list rose)
    (H : list_size size x < size (node l)) :
    list A :=
  aux x H by rec x (MR lt (list_size size)) :=
  aux nil H := nil;
  aux (cons a x) H := elements a ++ aux x _ _.

  Next Obligation. red; simpl; omega. Qed.
  Next Obligation. red; simpl; omega. Qed.
End RoseTree.

Compute elements
  (node [leaf 0; node [leaf 1; leaf 2]]).