Require Import Equations.Equations.

Inductive vect (A : Type) : nat -> Type :=
| vnil : vect A O
| vcons : forall (n : nat), A -> vect A n
     -> vect A (S n).

Arguments vnil {_}.
Arguments vcons {_ _} _ _.

Equations tail {A : Type}
  {n : nat} (v : vect A (S n)) : vect A n :=
tail (vcons _ v') := v'.

Check @tail.
Check tail_equation_1.



(* "with" clause *)

Equations unzip {A B : Type} {n : nat}
  (v : vect (A * B) n) :
  vect A n * vect B n :=
unzip vnil := (vnil, vnil) ;
unzip (vcons (pair a b) v) <= unzip v => {
  | pair v w => (vcons a v, vcons b w)
}.

Check @unzip.
Check unzip_equation_1.
Check unzip_equation_2.
Check unzip_helper_1_equation_1.

Equations nat_eqdec (n m : nat) :
  { n = m } + { n <> m } :=
nat_eqdec O O := left eq_refl ;
nat_eqdec (S n) (S m) <= nat_eqdec n m => {
    (* { n = n } + { n <> n } *)
  | left eq_refl := left eq_refl ;
    (* n <> m -> S n <> S m *)
  | right _ := right _
} ;
nat_eqdec _ _ := right _.



(* "by rec" *)

Require Import Arith.
Require Import Relations.

Inductive term : Set :=
| var : nat -> term
| abs : term -> term
| app : term -> term -> term.

Equations shift (x : nat) (t : term) :
  term :=
shift x (var y) := var (if le_gt_dec x y then
  (S y) else y);
shift x (abs t) := abs (shift (S x) t);
shift x (app t1 t2) :=
  app (shift x t1) (shift x t2).

Parameter order : relation term.
Parameter wf_order : WellFounded order.

Equations subst (t : term) (u : term)
  (x : nat) : term :=

subst t u x by rec t order :=

subst (var i) u x <= lt_eq_lt_dec i x => {
  | inleft (right _) := u;
  | inleft (left _) := var i;
  | inright _ := var (pred i)
};
subst (abs t) u x :=
  abs (subst t (shift O u) (S x));
subst (app t1 t2) u x <= subst t2 u x => {
  | r2 <= subst t1 u x => {
    | abs t' => subst t' r2 0 ;
    | r1 => app r1 r2
    }}.