Require Import Equations.Equations.
Require Import List.

Equations filter {A : Type} (P : A -> bool)
  (l : list A) : list A :=
filter P nil := nil;
filter P (cons a l) <= P a => {
  | true := cons a (filter P l);
  | false := filter P l
}.

Lemma filter_ok {A : Type} (P : A -> bool)
  (l : list A) :
  Forall (fun a => P a = true) (filter P l).
Proof.
  funelim (filter P l).
  - apply Forall_nil.
  - (* P a = true *)
    apply Forall_cons; assumption.
  - (* P a = false *)
    assumption.
Qed.